define(
    [
        'Magento_Checkout/js/view/payment/default',
        'Youlogix_Idebit/js/action/set-payment-method',
        'jquery',
        "mage/validation"
    ],
    function(Component,setPaymentMethod,$){
    'use strict';

    return Component.extend({
        defaults:{
            'template':'Youlogix_Idebit/payment/idebit',
            purchaseOrderCoin: ''
        },
        initObservable: function () {
            this._super()
                .observe('purchaseOrderCoin');
            return this;
        },
        getData: function () {
            return {
                "method": this.item.method,
                "additional_data":{
                    'coin_currency': this.purchaseOrderCoin(),
                    }
            };

        },
        validate: function () {
            var form = 'form[data-role=cointopay-form]';
            return $(form).validation() && $(form).validation('isValid');
        },
        redirectAfterPlaceOrder: false,
        
        afterPlaceOrder: function () {
            setPaymentMethod();    
        }
    });
});
